const parse = require('./parse-tradeven.js');
const fits = require('./lib-fits');
const path = require('path');
const iconv = require('iconv-lite');
const InvE = require('./class-InvE.js'); //電子發票檔：開立/作廢/作廢取消重開
const fs = require("fs");
const fsp = fs.promises;

const parse_inve_add = async(file) => {
    var value = await fsp.readFile(file);
    var data = iconv.decode(value, 'big5');
    var invno = path.parse(file).name;
    return new InvE.Add(invno, data);
}

const main = async() => {
    let file = path.join("test_json", "BM79088562.txt");

    var inve = await parse_inve_add(file);
    fits.writeLog("上傳檔案", file, JSON.stringify(inve));

    var body = await parse.add_r(inve);
    fits.writeLog("送出去的資料", JSON.stringify(body));
}
main();