var fs = require("fs");
const fsp = fs.promises;
var iconv = require('iconv-lite');
var InvE = require('./class-InvE.js'); //電子發票檔：開立/作廢/作廢取消重開
var TE = require('./class-Tradeven.js');
var api = require('./api-Tradeven.js');
// var dir = {};
var path = require('path');
var middle = require('./basic-middle.js');
var parse = require('./parse-tradeven.js');
var fits = require('./lib-fits.js');

var timer1 = null;
var timer2 = null;
var timer3 = null;

main();

async function main() {

    var dirs = await middle.getDir();
    if (fs.existsSync(dirs.add_r)) timer1_start(dirs);
}

function timer1_start(pDirs) {
    timer1 = setInterval(scanAdd_r, 1000 * 10, pDirs);
    fits.writeLog("開始U4(add_r)", pDirs.add_r);
};

function timer1_stop() {
    timer1 = clearInterval(timer1);
    fits.writeLog("暫停U4(add_r)");
};


async function scanAdd_r(dir) {

    try {
        var list = await fsp.readdir(dir.add_r);

        if (list.length == 0) { return; }

        timer1_stop();
        list.sort();

        for (let i = 0; i < list.length; i++) {
            var element = list[i];
            var file = dir.add_r + "\\" + element;
            console.log("i", i, file);
            await uploadAdd_r(file, dir);
        }

        timer1_start(dir);

    } catch (error) {
        fits.writeErr({ "檔案": __filename, "程序": arguments.callee.name, "錯誤": error.toString() });
    }
}





async function uploadAdd_r(file, dir) {
    try {

        var inve = await parse_inve_add(file);
        fits.writeLog("上傳檔案", file, JSON.stringify(inve));


        var body = await parse.add_r(inve);
        fits.writeLog("送出去的資料", JSON.stringify(body));


        var res = await api.add_invoice(body)
        fits.writeLog("收到的資料", JSON.stringify(res));

        var decrypted = "";
        if (res.Success == "Y" || res.Success == "N") {
            decrypted = api.decrypt(res.Message);
            fits.writeLog("收到的資料->解密", JSON.stringify(decrypted));
        }

        if (res.Success == "Y") {
            var bakDir = dir.path + "\\M" + inve.month;
            await fsp.rename(file, bakDir + "\\" + path.basename(file));
            await fits.saveSetting("BK3", "IP", "LastSend", fits.now() + path.parse(file).name);
            fits.writeLog("上傳完成", file);
        } else {
            fsp.rename(file, dir.err + "\\" + path.basename(file) + ".add_r")
            fits.writeLog("上傳錯誤->移至err目錄", dir.err + "\\" + path.basename(file));
            var errFile = path.join(dir.err, path.basename(file) + ".res");
            var line = "收到的資料：" + JSON.stringify(res) + fits.crlf;
            line += "收到的資料解密：" + JSON.stringify(decrypted);
            fsp.writeFile(errFile, line);
        }


    } catch (error) {
        fits.writeErr({ "檔案": __filename, "程序": arguments.callee.name, "錯誤": error.toString() });
    }
}





async function parse_inve_add(file) {
    var value = await fsp.readFile(file);
    var data = iconv.decode(value, 'big5');
    var invno = path.parse(file).name;
    return new InvE.Add(invno, data);
}