var fs = require("fs");
const fsp = fs.promises;
var middle = require('./basic-middle.js');
var bk35 = require('./lib-adodb.js');
var path = require("path");
var fits = require('./lib-fits.js');
const { findSourceMap } = require("module");

var timer1 = null;
var timer2 = null;
var timer3 = null;

main();

async function main() {

    var file = await middle.getFiles();

    var dir = await middle.getDir();

    timer1_start(file);

    timer2_start(file, dir);


    setTimeout(() => { //等10秒做一次
        scanInvNextTerm(file, dir);
    }, 1000 * 10);

    timer3_start(file, dir); //之前等1小時再重覆檢查

}

function timer1_start(file) {
    timer1 = setInterval(scanInvNOBE, 1000 * 1, file); // 檢查換下一批
    fits.writeLog("開始S1");
};

function timer1_stop() {
    timer1 = clearInterval(timer1);
    fits.writeLog("暫停S1");
};

function timer2_start(file, dir) {
    timer2 = setInterval(scanInvLast, 1000 * 1, file, dir); //當前批最後一張用完->刪除當前批
    fits.writeLog("開始S2");
};

function timer2_stop() {
    timer2 = clearInterval(timer2);
    fits.writeLog("暫停S2");
};

function timer3_start(file, dir) {
    timer3 = setInterval(scanInvNextTerm, 1000 * 3600, file, dir); //檢查換月份切至下一期
    fits.writeLog("開始S3-1hour");
};

function timer3_stop() {
    timer3 = clearInterval(timer3);
    fits.writeLog("暫停S3");
};




async function scanInvNOBE(file) { //如果當前批號不存在，檢查下一批符合營業日期->切換至當前批
    try {

        if (fs.existsSync(file.invNOBE)) return;
        // fits.writeLog("scanInvNOBE", file.invNOBE, fs.existsSync(file.invNOBE))
        // if (fs.existsSync(file.invNOBE)) {
        //     try {
        //         let line = await fsp.readFile(file.invNOBE);
        //         let array = line.toString().split(",");
        //         // fits.writeLog("scanInvNOBE", array[0], array[1]);
        //         if (array[0] == array[1]) {
        //             await fsp.unlink(file.invNOBE); //刪除發票批次
        //             fits.writeLog("scanInvNOBE", array[0], array[1], "起號與迄號相同，代表此批已用完->刪除檔案", file.invNOBE);
        //             return;
        //         }

        //     } catch (error) {
        //         fits.writeErr(__filename, "scanInvNOBE()", error.toString())
        //         return;
        //     }
        // }

        if (!fs.existsSync(file.invNOBENext)) { return; }

        if (!await checkTerm(file.invNOBENext)) { return; } // 先檢查、再切換


        timer1_stop();
        fits.writeLog("InvNOBE.txt不存在,調用InvNOBENext", )
        await useInvNOBENext(file);

        timer1_start(file);

    } catch (error) {
        fits.writeErr({ "檔案": __filename, "程序": arguments.callee.name, "錯誤": error.toString() });

    }

}


async function scanInvLast(file, dir) { // 如果下一張發票號被POS清空，刪除當前批號 
    // 檢查發票換批次的3種判斷方式     // 1.檢查invLast.txt的第1欄 = ""    // 2.檢查reg(IP).NextInvNo = ""    // 3.檢查reg(IP).POS = "InvOut"
    try {
        if (!fs.existsSync(file.invLast)) { return }

        var value = await fsp.readFile(file.invLast);
        var data = value.toString().split(",");
        data[0] = fits.str(data[0])
        data[1] = fits.str(data[1])


        if (data[0] == "" || data[0] == data[1]) { //該換批了 //BKPOS01用完該批號碼不會把invLast[0]填空白，會填成最後一張號碼

            try {
                timer2_stop();
                fits.writeLog(value, "該換批了")
                    // await fsp.unlink(file.invNOBE); //刪除發票批次
                if (!fs.existsSync(file.invNOBE)) { return }
                var value = await fsp.readFile(file.invNOBE);
                var data = value.toString().split(",");

                var lastInvNo = await fits.getSetting("BK3", "IP", "LastInvNo");


                if (lastInvNo == data[1]) { //如果當前批的最大號=最後改立的號碼=>移除當前批
                    fits.writeLog("rename", file.invNOBE, dir.bak + "\\" + path.basename(file.invNOBE))
                    await fsp.rename(file.invNOBE, dir.bak + "\\" + path.basename(file.invNOBE));
                }
            } catch (error) {
                fits.writeErr({ "檔案": __filename, "程序": "scanInvLast().try{timer2_stop()...}", "錯誤": error.toString() });
            } finally {
                setTimeout(() => {
                    timer2_start(file, dir);
                    fits.writeLog("換批重啟S2等候5秒")
                }, 1000 * 5);

            }


        }
    } catch (error) {
        fits.writeErr({ "檔案": __filename, "程序": arguments.callee.name, "錯誤": error.toString() });
    }
}


async function scanInvNextTerm(file, dir) { //如果下期發票存在、且下期發票符合當前營業日 -> 將當前批刪除，將下期移至下一批
    try {

        if (!fs.existsSync(file.invNextTerm)) { return; } // 下期批號不存在

        if (!await checkTerm(file.invNextTerm)) { return; } // 先檢查、再切換

        if (await haveBillCheck()) { return; } //已經在營業中，不能切換發票批次     

        timer1_stop();
        timer2_stop();
        timer3_stop();

        await fsp.rename(file.invNextTerm, file.invNOBENext); // 將下期覆蓋下一批

        await fsp.rename(file.invNOBE, dir.bak + "\\" + path.basename(file.invNOBE)); //將當前批移至bak目錄

        // fits.writeLog("切換期別", invYear, invMonth, isOpen, obj.year, obj.period);

        fits.writeLog("切換期別");
        timer1_start(file);
        timer2_start(file, dir);
        timer3_start(file, dir);

    } catch (error) {
        fits.writeErr({ "檔案": __filename, "程序": arguments.callee.name, "錯誤": error.toString() });
    }


}

async function haveBillCheck() { // 檢查當日是否開始營業;
    try {

        var posid = await fits.getSetting("BK3", "SYS", "POSID");
        var sql = " Select * from ocheck where opdate is null and POSID = " + fits.quot(posid);
        var data = await bk35.query(sql);

        if (data.length > 0) { return true; }

        return false;
    } catch (error) {
        fits.writeErr({ "檔案": __filename, "程序": arguments.callee.name, "錯誤": error.toString() });
    }
}


async function checkTerm(file) { //用opdate比對檔案，期別是否相同
    try {

        if (!fs.existsSync(file)) { return false; }

        var opdate = await getOPDateObj();
        var value = await fsp.readFile(file);
        var data = value.toString().split(",");

        if (opdate.year != data[3]) { return false; } // 年份不對

        if (opdate.period != data[4]) { return false; } //期別不對

        return true;
    } catch (error) {
        fits.writeErr({ "檔案": __filename, "程序": arguments.callee.name, "錯誤": error.toString() });
    }
}



async function useInvNOBENext(file) { // 將取得的發票批次寫入文字檔/reg

    try {
        var value = await fsp.readFile(file.invNOBENext);
        var data = value.toString().split(",");
        var inv = {};
        inv.MinInvNo = data[0];
        inv.MaxInvNo = data[1];
        inv.ApplyNumber = data[2];
        inv.InvYear = data[3];
        inv.InvMonth = data[4];
        inv.NextInvNo = data[0];

        fits.saveSetting("BK3", "IP", "MinInvNo", inv.MinInvNo);
        fits.saveSetting("BK3", "IP", "MaxInvNo", inv.MaxInvNo);
        fits.saveSetting("BK3", "IP", "ApplyNumber", inv.ApplyNumber);
        fits.saveSetting("BK3", "IP", "InvYear", inv.InvYear);
        fits.saveSetting("BK3", "IP", "InvMonth", inv.InvMonth);
        fits.saveSetting("BK3", "IP", "NextInvNo", inv.NextInvNo);


        var lastInvNo = "";
        if (fs.existsSync(file.invLast)) {
            value = await fsp.readFile(file.invLast);
            data = value.toString().split(",");
            lastInvNo = data[1];
        }

        var line = inv.NextInvNo + "," + lastInvNo;
        await middle.writeInvLast(line);
        //  fsp.rename(file.invNOBENext, file.invNOBE); // bugfix 沒有使用到await
        await fsp.rename(file.invNOBENext, file.invNOBE);
        fits.writeLog("使用批號", JSON.stringify(inv));
    } catch (error) {
        fits.writeErr({ "檔案": __filename, "程序": arguments.callee.name, "錯誤": error.toString() });
    }


}

async function getOPDateObj() {
    try {
        var opdate = await bk35.getParam("opdate");
        var year = fits.val(opdate.substring(0, 4)) - 1911;
        var month = fits.val(opdate.substring(5, 7).toString());
        var period = "";

        if (month <= 2) {
            period = "01-02";
        } else if (month <= 4) {
            period = "03-04";
        } else if (month <= 6) {
            period = "05-06";
        } else if (month <= 8) {
            period = "07-08";
        } else if (month <= 10) {
            period = "09-10";
        } else if (month <= 12) {
            period = "11-12";
        }
        return { year: year.toString(), period, period };
    } catch (error) {
        fits.writeErr({ "檔案": __filename, "程序": arguments.callee.name, "錯誤": error.toString() });
    }

}