var pkg = require("./package.json");
var version = pkg.version;
var fs = require('fs');
var fsp = fs.promises;
var middle = require('./basic-middle.js');
var bk35 = require('./lib-adodb');
var fits = require('./lib-fits');

// const ver = "R.2023-11-13";
fits.writeLog(__dirname, version);


var InvE = require('./class-InvE.js'); //電子發票檔：開立/作廢/作廢取消重開
var parse = require('./parse-tradeven');
// 應稅100
// 2023/05/02,14:30:49,230502P10002,,,,1715,100,0,100,1,,,0
// var tmp = new InvE.Add("PH38316534", "2023/05/02,14:30:49,230502P10002,,,,1715,100,0,100,1,,,0");
// var body = parse.add(tmp);

// 免稅100
// 2023/05/02,14:30:57,230502P10003,,,,2902,100,0,100,1,,,100
// var tmp = new InvE.Add("PH38316535", "2023/05/02,14:30:57,230502P10003,,,,2902,100,0,100,1,,,100");
// var body = parse.add(tmp);

// 應稅100+統編
// 2023/05/02,14:31:53,230502P10004,12967293,,,2608,95,5,100,1,,,0
// var tmp = new InvE.Add("PH38316536", "2023/05/02,14:31:53,230502P10004,12967293,,,2608,95,5,100,1,,,0");
// var body = parse.add(tmp);

// 免稅100+統編
// 2023/05/02,14:32:04,230502P10005,12967293,,,5543,100,0,100,1,,,100
// var tmp = new InvE.Add("PH38316537", "2023/05/02,14:32:04,230502P10005,12967293,,,5543,100,0,100,1,,,100");
// var body = parse.add(tmp);

// 混合200
// 2023/05/02,14:34:46,230502P10006,,,,9518,100,0,200,1,,,100
// var tmp = new InvE.Add("PH38316538", "2023/05/02,14:34:46,230502P10006,,,,9518,100,0,200,1,,,100");
// var body = parse.add(tmp);

// 混合200+統編
// 2023/05/02,14:34:58,230502P10007,12967293,,,1958,95,5,200,1,,,100
// var tmp = new InvE.Add("PH38316539", "2023/05/02,14:34:58,230502P10007,12967293,,,1958,95,5,200,1,,,100");
// var body = parse.add(tmp);


// fits.writeLog("送出去的資料", JSON.stringify(body));

// const test0223 = () => { // debug 檢查發票切換失敗原因
//     // require("./processor-invsrv.js"); // 啟動程序：發票切換 (*本期2->本期1 / *下期->本期2->本期1)
//     require("./processor-download-inv.js"); // 啟動程序：取號
// }
// test0223()

main();
async function main() {
    try {
        // return;

        if (!await checkData()) { return; } // 啟動檢查

        fits.writeLog("電子發票服務(關貿).程式版本", version);

        fits.writeLog("啟動參數", JSON.stringify(fits.ini));


        require("./processor-download-inv"); // 啟動程序：監聽發票批號下載(本期1/本期2/下期)

        require("./processor-upload-inv"); // 啟動程序：監聽發票上傳(ADD/VOID/UNVOID)

        require("./processor-invsrv.js"); // 啟動程序：發票切換 (*本期2->本期1 / *下期->本期2->本期1)


        require("./processor-upload-addr"); // 啟動程序：監聽發票上傳(ADD/VOID/UNVOID)

    } catch (error) {
        fits.writeErr({ 檔案: __filename, 程序: arguments.callee.name, 錯誤: error.toString() });
    }
}


async function checkData() {
    try {

        var dir = await middle.getDir();
        var file = await middle.getFiles();
        var ip = await fits.getSetting("BK3", "IP");
        var sys = await fits.getSetting("BK3", "SYS");
        var bno = await bk35.getParam("InvHead1");

        var errors = [];

        if (sys.InvE == "") {
            errors.push(" reg.InvE <> Y");
        }

        if (!fs.existsSync(dir.path)) {
            errors.push("電子發票資料夾不存在" + dir.path);
        }

        if (bno == "" || bno.length != 8) {
            errors.push("統編設定錯誤(InvHead1)" + bno);
        }

        if (bno != ip.BNO) {
            errors.push("InvHead1跟reg.BNO不同,InvHead:" + bno + ",reg.BNO" + ip.BNO);
        }

        if (!fs.existsSync(file.invData)) {
            errors.push("檔案不存在" + file.invData);
        }

        if (fits.str(ip.QRCode) != "Tradeven") {
            errors.push("reg.QRCode必需等於'Tradeven'");
        }

        if (errors.length > 0) {
            fits.writeLog("啟動服務失敗->請檢查設定", JSON.stringify(errors));
            fits.showMsg("啟動服務失敗->請檢查設定", JSON.stringify(errors));
            return false;
        }

        return true;

    } catch (error) {
        return fits.writeErr({ "檔案": __filename, "程序": arguments.callee.name, "錯誤": error.toString() });
    }

}