var fs = require('fs');
var fsp = fs.promises;
var moment = require('moment');
var INI = require('ini');
var ini = INI.parse(fs.readFileSync('./app.ini', 'utf-8'));
// var regedit = require('regedit');
var ftp = require("basic-ftp");
var path = require("path");
const cp = require("child_process");
var { v4: uuid } = require('uuid');
var zeroFill = require('zero-fill')

if (!fs.existsSync("log")) { fs.mkdirSync("log"); }

if (!fs.existsSync("patch")) { fs.mkdirSync("patch"); }

var config = { host: "61.219.255.37", user: "store", password: "store", secure: false };

module.exports = {
    ini: ini,
    crlf: '\r\n',
    tab: String.fromCharCode(9),


    async mkdir(dir) {
        await fsp.mkdir(dir, { recursive: true });
    },

    str(value) {
        try {
            if (value == undefined) { return "" };
            if (value == null) { return "" };
            return value.toString().trim();
        } catch (error) {
            return "";
        }
    },

    quot(value, len = 0) {
        if (len > 0) { value = value.substring(0, len) }
        return "'" + this.str(value) + "'";
    },
    quotes(value, len = 0) {
        if (len > 0) { value = value.substring(0, len) }
        return '"' + this.str(value) + '"';
    },

    val(value) {
        return Number(this.str(value));
    },

    today() {
        return moment().format("YYYY-MM-DD");
    },

    now() {
        return moment().format("YYYY-MM-DD HH:mm:ss");
    },


    /**
     *  @type {(value: string, find: string, replace: string) => string } 
     */

    replace(value, find, replace) {
        return value.replace(RegExp(find, "g"), replace);
    },

    // ini() {
    //     return ini;
    // },

    writeLog(...text) {
        var date = moment().format("YYYYMMDD");
        var file = './log/' + date + '.log';
        var line = this.now() + ' ' + text;

        fs.appendFile(file, line + this.crlf, function(err) {
            if (err)
                console.log(err);
            else
                console.log(line);
        });
    },

    writeErr(...text) {
        var date = moment().format("YYYYMMDD");
        var file = './log/' + date + '.err';
        var line = this.now() + ' ' + JSON.stringify(text);
        this.writeLog(JSON.stringify(text));

        fs.appendFile(file, line + this.crlf, (err) => {});
    },


    /**
     *  @type {(project: "BK3", section: "SYS" | "IP", key:string , value:string)=> Promise<any> } 
     */
    async saveSetting(project, section, key, value) {
        try {
            var cmd = "reg add ";
            cmd += this.quotes("HKCU\\SOFTWARE\\VB and VBA Program Settings\\" + project + "\\" + section);
            cmd += " /v " + this.quotes(key);
            cmd += " /t " + this.quotes("REG_SZ");
            cmd += " /d " + this.quotes(value);
            cmd += " /f ";

            return new Promise((resolve, reject) => {
                cp.exec(cmd, { windowsHide: true }, (error, stdout, stderr) => {
                    if (error) { reject(error); }

                    if (stderr) { reject(stderr); }

                    resolve();
                });
            });

        } catch (error) {
            fits.writeErr({ 檔案: __filename, 程序: "saveSetting", 錯誤: error.toString() });
        }
    },


    /**
     *  @type {(project: "BK3", section: "SYS" | "IP" key: string)=> Promise<string> } 
     */
    async getSetting(project, section, key = "") {
        try {
            var cmd = "reg query ";
            cmd += this.quotes("HKCU\\SOFTWARE\\VB and VBA Program Settings\\" + project + "\\" + section);

            return new Promise((resolve, reject) => {
                cp.exec(cmd, { windowsHide: true }, (error, stdout, stderr) => {
                    if (error) { reject(error); }

                    if (stderr) { reject(stderr); }

                    var data = parseReg(stdout.trim());

                    if (key != "") { resolve(data[key]); }

                    resolve(data);
                });
            });

        } catch (error) {
            fits.writeErr({ 檔案: __filename, 程序: "getSetting", 錯誤: error.toString() });
        }
    },




    // **********************
    // ftpPut:上傳指定檔案
    // await fits.ftpPut("D:/NODE19/_NODE安裝版本/node-v12.22.12-x86.msi") ;
    // **********************
    async ftpPut(localFile, remoteDir = "") {

        try {
            var client = new ftp.Client(); // 建立ftp連線 timeout=30秒
            // client.ftp.verbose = true // 顯示ftp server的訊息
            var remoteFile = remoteDir + "/" + path.basename(localFile);
            await client.access(config);
            await client.uploadFrom(localFile, remoteFile);
            client.close();
        } catch (error) {
            this.writeErr({ 檔案: __filename, 程序: "ftpPut", 錯誤: error.toString() });
        }
    },



    // **********************
    // ftpList:取得目錄清單
    // var list = await fits.ftpList("20200623_測試");
    // console.log("ftpList", JSON.stringify(list, ["name", "type"]));
    // **********************
    async ftpList(remoteDir = "") {
        // console.log(this.callee.name);
        try {
            var client = new ftp.Client(); // 建立ftp連線 timeout=30秒
            await client.access(config);
            return await client.list(remoteDir);
        } catch (error) {
            this.writeErr({ 檔案: __filename, 程序: "ftpList", 錯誤: error.toString() });
        }
    },






    // **********************
    // ftpGet:取得檔案
    // await fits.ftpGet("CTK.exe", "D:/_TODO/");
    // **********************
    async ftpGet(remoteFile, localDir = "") {
        try {
            var client = new ftp.Client(); // 建立ftp連線 timeout=30秒
            // client.ftp.verbose = true // 顯示ftp server的訊息
            await client.access(config);

            if (localDir == "") {
                var localFile = path.basename(remoteFile);
            } else {
                var localFile = localDir + "/" + path.basename(remoteFile);
            }

            await client.downloadTo(localFile, remoteFile);

            client.close();
        } catch (error) {
            this.writeErr({ 檔案: __filename, 程序: "ftpGet", 錯誤: error.toString() });
        }
    },



    // **********************
    // ftpPutAll:本地目錄->ftp目錄
    // await fits.ftpPutAll("D:/StoreSS", "20200623_測試");
    // **********************
    async ftpPutAll(localDir, remoteDir = "") {

        try {
            var client = new ftp.Client(); // 建立ftp連線 timeout=30秒
            await client.access(config);
            await client.uploadFromDir(localDir, remoteDir);
            client.close();
        } catch (error) {
            this.writeErr({ 檔案: __filename, 程序: "ftpPutAll", 錯誤: error.toString() });
        }
    },


    // **********************
    // ftpGetAll:ftp目錄->本地目錄
    // 將ftp上的目錄完整結構下載到本地端(資料夾會自動建立)，當指定的本地資料夾不存在時(資料夾會自動建立)
    // await fits.ftpGetAll("StoreSS", "D:/StoreSS");
    // **********************
    async ftpGetAll(remoteDir, localDir = __dirname) {

        try {
            var client = new ftp.Client(); // 建立ftp連線 timeout=30秒
            await client.access(config);
            console.log(localDir, remoteDir);
            await client.downloadToDir(localDir, remoteDir);
            client.close();
        } catch (error) {
            this.writeErr({ 檔案: __filename, 程序: "ftpGetAll", 錯誤: error.toString() });
        }
    },



    // **********************
    // zip:壓縮檔案
    // 目錄需有工具程式7za.exe , 
    // var res = await fits.zip("CTK.7z", "CTK.exe");
    // **********************
    async zip(zipFile, ...srcFile) {
        try {
            // srcFile = JSON.stringify(srcFile);
            srcFile = srcFile.toString();
            srcFile = this.replace(srcFile, ",", " ");

            console.log("src", srcFile);
            cmd = '7za a -tzip ' + zipFile + ' ' + srcFile;
            if (fs.existsSync(zipFile)) { await fsp.unlink(zipFile) };
            return new Promise((resolve, reject) => {
                cp.exec(cmd, { windowsHide: true }, (error, stdout, stderr) => {
                    if (error) { reject(error); }
                    if (stderr) { reject(stderr); }
                    resolve(stdout);
                });
            });
        } catch (error) {
            this.writeErr({ 檔案: __filename, 程序: "zip", 錯誤: error.toString() });
        }
    },


    // **********************
    // zip:壓縮檔案
    // 目錄需有工具程式7za.exe , 
    // var res = await fits.unzip("CTK.7z");
    // **********************
    async unzip(zipFile, outDir = ".") {
        try {
            var cmd = '7za x -tzip ' + zipFile;
            var cmd = '7za x "invSrv(TV).7z" -o"../" -y';
            var cmd = '7za x "' + zipFile + '" -o"' + outDir + '" -y';
            return new Promise((resolve, reject) => {
                cp.exec(cmd, { windowsHide: true }, (error, stdout, stderr) => {
                    if (error) { reject(error); }
                    if (stderr) { reject(stderr); }
                    resolve(stdout);
                });
            });
        } catch (error) {
            this.writeErr({ 檔案: __filename, 程序: "unzip", 錯誤: error.toString() });
        }
    },


    // **********************
    // exec:壓縮檔案
    // 目錄需有工具程式7za.exe , 
    // var res = await fits.unzip("CTK.7z");
    // cp.execFile->可帶參數，執行程式可含路徑
    // cp.exe->不可帶參數，執行程式不能有路徑
    // **********************
    async execFile(exe, ...args) {
        try {
            return new Promise((resolve, reject) => {
                cp.execFile(exe, args, (error, stdout, stderr) => {
                    if (error) { reject(error); }
                    if (stderr) { reject(stderr); }
                    resolve(stdout);
                });
            });
        } catch (error) {
            this.writeErr({ 檔案: __filename, 程序: "unzip", 錯誤: error.toString() });
        }
    },

    // **********************
    // exec:壓縮檔案
    // 目錄需有工具程式7za.exe , 
    // var res = await fits.unzip("CTK.7z");
    // cp.execFile->可帶參數，執行程式可含路徑
    // cp.exe->不可帶參數，執行程式不能有路徑
    // **********************
    async exec(cmd) {
        try {
            return new Promise((resolve, reject) => {
                cp.exec(cmd, { windowsHide: true }, (error, stdout, stderr) => {
                    if (error) { reject(error); }
                    if (stderr) { reject(stderr); }
                    resolve(stdout);
                });
            });
        } catch (error) {
            this.writeErr({ 檔案: __filename, 程序: "exec", 錯誤: error.toString() });
        }
    },

    async showMsg(...txt) {
        try {

            var msgFile = "./log/" + uuid() + ".txt";
            await fsp.writeFile(msgFile, txt);
            await this.exec("notepad " + msgFile);
            await fsp.unlink(msgFile);
        } catch (error) {
            this.writeErr({ 檔案: __filename, 程序: "showMsg", 錯誤: error.toString() });
        }
    },

    zeroFill(len, number) {
        try {
            return zeroFill(len, number);
        } catch (error) {
            fits.writeErr({ 檔案: __filename, 程序: "zeroFill", 錯誤: error.toString() });
        }
    }


};


function parseReg(value) { // 解析取得的reg字串
    try {
        var data = [];
        var output = {};
        data = value.split('\r\n');
        data.forEach(element => {
            element = element.trim();
            var row = element.split("    ");
            if (row.length == 3) {
                output[row[0]] = row[2];
            }
        });
        return output;
    } catch (error) {
        console.log("錯誤", error.toString());
    }
}