var { v4: uuid } = require('uuid');
var moment = require('moment');

class IssueData {
    // G：開立發票  (發票首次上傳且已開立)
    // R：重開發票  (作廢重開)
    constructor(type = "G") {
        this.type = type;
    }

    companyUn = ""; // 公司統一編號 String 8 V
    orgId = ""; // 事業別代碼 String 5 V
    orgUn = ""; // 事業別統一編號 String 8 V
    type = ""; // 類別 String 1 V    G:開立發票      R:重開發票
    saleIdentifier = ""; // 銷售單識別碼 String 100 V
    transactionNumber = ""; // 銷售單交易編號 String 50 V
    transactionDate = ""; // 銷售單交易日期 String 8 V
    transactionTime = ""; // 銷售單交易時間 String 8 V
    invoiceNumber = ""; // 發票號碼 String 10 V
    checkNumber = ""; // 隨機碼 String 4 V
    invoiceDate = ""; // 發票日期 String 8 V
    invoiceTime = ""; //發票時間 String 8 V
    texclusiveAmount = ""; //應稅發票總銷售額(未稅) String 20 V
    oexclusiveAmount = ""; //免稅發票總銷售額 String 20 V
    zexclusiveAmount = ""; // 零稅率發票總銷售額 String 20 V
    tax = ""; // 發票稅額 String 20 V
    total = ""; //銷售總金額 / 折讓總金額 / 發票總金額 String 20 V
    // donate = ""; // 發票是否捐贈 String 1 V
    // donationUnit = ""; // 	發票捐贈單位	String	10
    // carrierType = ""; // 	發票載具類型	String	6
    // carrierId = ""; // 	發票載具編號顯碼	String	64
    // carrierIdHidden = ""; // 	發票載具編號隱碼	String	64
    // buyerUn = ""; // 統一編號	String	8
    invoiceType = "" //若Type為「I」、「R」、「G」則必填	"07：一般稅額計算之電子發票        
    paperPrintMode = ""; // 消費者發票或折讓列印之方式 String 1 V
    invoiceAlarmMode = ""; //發票或折讓之通知方式 String 1 V
    itemList = [] // 發票明細項目(Item List of eGUI) List < IssueItem > V

    getData() { return this; }
}

class IssueData_ItemList {
    saleIdentifier = ""; // 銷售單識別碼	String	100	V	V	必填	"當IssueData的type=I、G、R時，同IssueData saleIdentifier 當IssueData的type=A、H時，欲折讓之發票銷售單識別碼"
    serialNumber = ""; // 	銷售項目序號/折讓項目序號	String	4	V	V	必填	"0001,0002,0003…    若Type為「A 」、「H」，需列出對應銷售項目序號"
    // invoiceNumber= "" ;// 	發票號碼	String	10			若Type為「H」、「A 」，則必填	
    // invoiceDate= "" ;// 	發票日期	String	8				若Type為「H」、「A 」，則必填			
    productCode = ""; // 收費代碼;產品編碼	String	30	V	V		
    productName = ""; // 銷售品項/折讓品項	String	300	V	V	必填	
    qty = ""; // 	銷售數量/折讓數量	String	20	V	V	必填	
    price = ""; // 單價(含稅)	String	20	V	V	必填	
    // tax= "" ;// 	品項稅額	String	20	V	V	非必填	
    // itemExclude= "" ;// 	品項未稅銷售額/品項未稅折讓額	String	20			若Type為「A 」和「H」，則必填	若為折讓，指不含稅之進貨額
    itemTotal = ""; // 	品項含稅銷售額/品項含稅折讓額	String	20	V	V	必填	
    taxType = ""; // 銷稅稅別	String	1	V	V	必填	"T：應稅    O：免稅    Z：零稅率"
    // description	= "" ;// 產品描述	String	300			非必填	

    getData() { return this; }
}



// TODO：使用aes加密event_id => event_verification
class MarkSerialInterval {
    acnt = ""; // String 64 API 串接驗證使用的帳號
    acntp = ""; // p String 64 API 串接驗證使用的密碼
    event_id = uuid(); //  String 100 Webhook UUID 識別碼
    event_time = moment().format("YYYY-MM-DD HH:mm:ss"); //  String26 Webhook 請求時間
    event_verification = ""; //  String200 Webhook 身分識別加密字串 (以雙方協定之 AES-KEY 對 event_id 進行加密 後，使用 Base64 轉編 碼)
    event_encode = "N"; //  String1    meta 是否為 encode Data(Y / N)    
    event_type = "apply.markserialinterval"; //  String60    Webhook 請求類別: "apply.markserialinterval"  (字軌取號申請) 
    meta_count = "1"; //  String4 取號資訊物件陣列筆數
    meta = [];
    getData() { return this; }
}

class MarkSerialInterval_Meta {
    serialnumber = "0001"; //  String4 流水號
    companyun = ""; //  String10 總公司統一編號
    orgid = ""; //  String6 事業別代號
    booktype = "UI"; //  String10    // 字軌使用類別:    API:API 傳輸  UI: UI 開立  BATCH: 批次傳輸
    period = ""; //  String6 取號所屬期別
    numrange = "50"; //  String8    // 取號(字軌需用數量)   當fullnumrange = Y 時此欄位填空白
    fullnumrange = "N"; //  String1 是否取整段字軌(Y/N)
    getData() { return this; }
}


class VoidData {
    // I ：發票作廢
    // C： 發票註銷 -> do next 作廢重開
    constructor(type = "I") {
        this.type = type;
    }
    type = "I"; //	作業類別	String	1	必填，內容需符合說明	"C： 發票註銷 I： 發票作廢 A： 折讓作廢 "
    //  companyUn = "" // 總公司統編 String 8 若Type為「 A」 時必填
    saleIdentifier = ""; // 銷售單識別碼 String 100 若Type為「 C」 或「 I」 則此欄位必填
    invoiceNumber = ""; // 發票號碼 String 10 若Type為「 C」 或「 I」 則此欄位必填
    invoicePaperReturned = "Y"; // 發票紙本是否已收回 String 1 若Type為「 C」 或「 I」 且該發票為個人戶則此欄位必填 Y是 / N否
    // allowanceNumber = "" // 折讓單號碼 String 16 若Type為「 A」 則此欄位必填
    // allowancePaperReturned = "" // 折讓單是否已簽回 String 1 Y是 / N否

    getData() { return this; }
}


module.exports = {
    IssueData: IssueData,
    ItemList: IssueData_ItemList,
    MarkSerialInterval: MarkSerialInterval,
    Meta: MarkSerialInterval_Meta,
    VoidData: VoidData,
}