var fs = require('fs');
var INI = require('ini');
var ini = INI.parse(fs.readFileSync('./app.ini', 'utf-8'));
var axios = require('axios');
const crypto = require('crypto');
// log.writeLog(JSON.stringify(ini));
// config {"method":"POST","url":"https://ecitest.tradevan.com.tw/DEFAULTAPI/apply/markserialinterval","headers":{"Content-Type":"application/json"},"data":{"acnt":"ECI00018T","acntp":"Sm3kGfbpZfJ42fTamPopLE9MKqTb1aJ7","event_time":"2022-11-23 11:58:18","event_id":"68a69982-9d6b-4786-acfa-2865be6bec1f","event_verification":"yOi7dVN7lLEb0Fth5yDTWaYA4QvwODPu2PBQgVyMj91uWzJkuHnUf8GIW5ccSppj","event_type":"apply.markserialinterval","event_encode":"N","meta_count":"1","meta":[{"serialnumber":"0001","companyun":"12967293","orgid":"ECI2C","booktype":"BATCH","period":"202212","numrange":"50","fullnumrange":"N"}]}}
// 2022/11/23 11:58:18 送出的資料,{"acnt":"ECI00018T","acntp":"Sm3kGfbpZfJ42fTamPopLE9MKqTb1aJ7","event_time":"2022-11-23 11:58:18","event_id":"68a69982-9d6b-4786-acfa-2865be6bec1f","event_verification":"yOi7dVN7lLEb0Fth5yDTWaYA4QvwODPu2PBQgVyMj91uWzJkuHnUf8GIW5ccSppj","event_type":"apply.markserialinterval","event_encode":"N","meta_count":"1","meta":[{"serialnumber":"0001","companyun":"12967293","orgid":"ECI2C","booktype":"BATCH","period":"202212","numrange":"50","fullnumrange":"N"}]}
// 2022/11/23 11:58:18 取號成功,{"resultdata":[{"serialnumber":"0001","companyun":"12967293","orgid":"ECI2C","orgun":"12967293","booktype":"BATCH","period":"202212","numrange":"50","fullnumrange":"N","success":"N","failreason":"S_R29^沒有足夠的字軌可分配"}],"event_id":"68a69982-9d6b-4786-acfa-2865be6bec1f","responsetime":"2022/11/23 11:58:19","code":"200","message":"Success","result_count":"1"}

module.exports = {
    encrypt: function(data, key, outputEncoding = "base64") { ///加密
        var bData = Buffer.from(data, "utf-8");
        while (bData.length % 16 > 0) { //不足16位，補空白至16位
            bData = Buffer.concat([bData, Buffer.from([0])]);
        }
        var iv = Buffer.from(key, 'utf-8');
        var cipher = crypto.createCipheriv("aes-128-cbc", key, iv);
        var update = cipher.update(bData);
        var final = cipher.final();
        var encrypted = {};
        encrypted.update = update.toString(outputEncoding); // 沒有final，加密結果才與關貿一直
        encrypted.update_and_final = Buffer.concat([update, final]).toString(outputEncoding); // 有final解密才正確
        return encrypted;
    },
    decrypt: function(data, key = ini.PrivateKey, outputEncoding = "utf-8") { ///解密
        var bData = Buffer.from(data, "base64");
        var iv = Buffer.from(key, 'utf-8');
        var cipher = crypto.createDecipheriv("aes-128-cbc", key, iv);
        // var output = Buffer.concat([cipher.update(bData)]).toString(outputEncoding);
        var output = Buffer.concat([cipher.update(bData)]).toString(outputEncoding);
        // output += "}";
        return output;
    },
    next_term: function(body) { //取得下一批發票號碼
        var config = {
            method: 'POST',
            url: ini.URL + '/apply/markserialinterval',
            headers: {
                'Content-Type': 'application/json'
            },
            data: body,
        };
        // console.log("config", JSON.stringify(config));
        return new Promise((resolve, reject) => {
            axios(config)
                .then((response) => { resolve(response.data); })
                .catch((error) => { reject(error); });
        });
    },

    add_invoice: function(body) { // 開立發票 / 重開發票(作廢重開.第2步)
        var config = {
            method: 'POST',
            url: ini.URL + '/post/issueLong',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded'
            },
            data: body,
        };

        return new Promise((resolve, reject) => {
            axios(config)
                .then((response) => { resolve(response.data); })
                .catch((error) => { reject(error); });
        });
    },

    void_invoice: function(body) { // 作廢發票 / 註銷發票(作廢重開.第1步)
        var config = {
            method: 'POST',
            url: ini.URL + '/post/cancelLong',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded'
            },
            data: body,
        };

        return new Promise((resolve, reject) => {
            axios(config)
                .then((response) => { resolve(response.data); })
                .catch((error) => { reject(error); });
        });
    }
};